/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoXMLProperties;
import DE.siemens.ad.logo.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TheodolitePanel
extends BorderJPanel {
    AstronomicalClockParameter parameter;
    private JPanel namePanel;
    private JPanel longitudePositionPanel;
    private JPanel latitudePositionPanel;
    private JPanel timeZonePanel;
    private JLabel longitudeLabel;
    private JLabel latitudeLabel;
    private EditableNumericSpinner longitudeDegree;
    private EditableNumericSpinner latitudeDegree;
    private EditableNumericSpinner longitudeMinute;
    private EditableNumericSpinner latitudeMinute;
    private EditableNumericSpinner longitudeSecond;
    private EditableNumericSpinner latitudeSecond;
    private JLabel timeZoneLabel;
    private JComboBox timeZoneComboBox;
    private JComboBox longitudeComboBox;
    private JComboBox latitudeComboBox;
    private JComboBox fJComboBox;
    private JPanel cityListPanel;
    private JButton saveButton;
    private JButton removeButton;
    private JTextField cityName;
    private JLabel cityNameLabel;

    public TheodolitePanel(AstronomicalClockParameter parameter) {
        this.parameter = parameter;
        this.setLayout(new GridBagLayout());
        this.init();
    }

    private void init() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.getCityListPanel(), gbc);
        BorderJPanel cityInfoPanel = new BorderJPanel(new GridBagLayout());
        cityInfoPanel.setTitle(Language.getString("dialog.parameter.astronomical.cityInfo", "City Information"));
        this.saveButton = new JButton(Language.getString("dialog.parameter.astronomical.save", "Save"));
        this.saveButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (TheodolitePanel.this.cityName.getText().equals("")) {
                    new LogoError(Language.getString("dialog.parameter.astronomical.cityNameNull", "Please enter a location.")).display();
                    return;
                }
                Vector<String> cityInfo = new Vector<String>(0);
                cityInfo.add(TheodolitePanel.this.getLongitude().toString());
                cityInfo.add(TheodolitePanel.this.getLatitude().toString());
                cityInfo.add(String.valueOf(TheodolitePanel.this.getTimeZone()));
                if (LogoXMLProperties.getInstance().addCityInfo(TheodolitePanel.this.cityName.getText(), cityInfo) && TheodolitePanel.this.cityName.isVisible()) {
                    TheodolitePanel.this.fJComboBox.addItem(TheodolitePanel.this.cityName.getText());
                    TheodolitePanel.this.fJComboBox.setSelectedItem(TheodolitePanel.this.cityName.getText());
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(0, 5, 5, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        cityInfoPanel.add((Component)this.getNamePanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        cityInfoPanel.add((Component)this.getLongitudePositionPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        cityInfoPanel.add((Component)this.getLatitudePositionPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        cityInfoPanel.add((Component)this.getTimeZonePanel(), constraints);
        constraints.anchor = 13;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        cityInfoPanel.add((Component)new JPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 5, 5, 5);
        cityInfoPanel.add((Component)this.saveButton, constraints);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)cityInfoPanel, gbc);
    }

    public JPanel getNamePanel() {
        if (this.namePanel == null) {
            this.namePanel = new JPanel(new GridBagLayout());
            this.cityName = new LengthRestrictedJTextField(25){

                public Dimension getPreferredSize() {
                    return new Dimension(160, 20);
                }
            };
            this.cityNameLabel = new JLabel(Language.getString("dialog.parameter.astronomical.cityName", "City"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(0, 10, 5, 10);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.namePanel.add((Component)this.cityNameLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 19, 5, 10);
            this.namePanel.add((Component)this.cityName, gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.namePanel.add((Component)new JPanel(), gbc);
        }
        return this.namePanel;
    }

    private JPanel getCityListPanel() {
        if (this.cityListPanel == null) {
            this.cityListPanel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(Language.getString("dialog.parameter.astronomical.city", "City"));
            this.fJComboBox = new JComboBox(LogoXMLProperties.getInstance().getCityNameList());
            this.fJComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String selectedObject = e.getItem().toString();
                        TheodolitePanel.this.setCityInfo(selectedObject);
                        TheodolitePanel.this.setComponentEditable(selectedObject);
                    }
                }
            });
            this.removeButton = new JButton(Language.getString("wizard.update.selectUpdateFilesPanel.remove", "Remove"));
            this.removeButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    LogoXMLProperties.getInstance().removeCityInfo(TheodolitePanel.this.fJComboBox.getSelectedItem().toString());
                    TheodolitePanel.this.fJComboBox.removeItem(TheodolitePanel.this.fJComboBox.getSelectedItem());
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 0);
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.cityListPanel.add((Component)label, gbc);
            gbc.insets = new Insets(5, 10, 5, 0);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.cityListPanel.add((Component)this.fJComboBox, gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            this.cityListPanel.add((Component)this.removeButton, gbc);
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.cityListPanel.add((Component)new JPanel(), gbc);
        }
        return this.cityListPanel;
    }

    public JPanel getTimeZonePanel() {
        if (this.timeZonePanel == null) {
            this.timeZonePanel = new JPanel();
            this.timeZonePanel.setLayout(new GridBagLayout());
            this.timeZoneLabel = new JLabel(Language.getString("dialog.parameter.astronomical.selectTimeZone", "Time Zone (E+; W-):") + ": ");
            this.timeZoneComboBox = new JComboBox<String>(this.getTimeZoneData());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 10, 5, 0);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.timeZonePanel.add((Component)this.timeZoneLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.timeZonePanel.add((Component)this.timeZoneComboBox, gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.timeZonePanel.add((Component)new JPanel(), gbc);
        }
        return this.timeZonePanel;
    }

    public JPanel getLongitudePositionPanel() {
        if (this.longitudePositionPanel == null) {
            this.longitudePositionPanel = new JPanel();
            this.longitudePositionPanel.setLayout(new GridBagLayout());
            this.longitudeLabel = new JLabel(Language.getString("dialog.parameter.astronomical.longitude", "Longitute") + ": ");
            String[] longitudeData = new String[]{"E", "W"};
            this.longitudeComboBox = new JComboBox<String>(longitudeData);
            this.longitudeDegree = new EditableNumericSpinner();
            this.longitudeMinute = new EditableNumericSpinner();
            this.longitudeSecond = new EditableNumericSpinner();
            this.longitudeDegree.setMinMax(0, 180);
            this.longitudeDegree.addNumericSpinnerListener(new DegreeInputListener(0));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 10, 10, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.longitudePositionPanel.add((Component)this.longitudeLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 10, 10, 0);
            this.longitudePositionPanel.add((Component)this.longitudeComboBox, gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            this.longitudePositionPanel.add((Component)this.longitudeDegree, gbc);
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 5, 10, 0);
            this.longitudePositionPanel.add((Component)new JLabel("\u00b0"), gbc);
            gbc.gridx = 4;
            gbc.gridy = 0;
            this.longitudePositionPanel.add((Component)this.longitudeMinute, gbc);
            gbc.gridx = 5;
            gbc.gridy = 0;
            this.longitudePositionPanel.add((Component)new JLabel("'"), gbc);
            gbc.gridx = 6;
            gbc.gridy = 0;
            this.longitudePositionPanel.add((Component)this.longitudeSecond, gbc);
            gbc.insets = new Insets(4, 5, 10, 10);
            gbc.gridx = 7;
            gbc.gridy = 0;
            this.longitudePositionPanel.add((Component)new JLabel("\""), gbc);
        }
        return this.longitudePositionPanel;
    }

    public JPanel getLatitudePositionPanel() {
        if (this.latitudePositionPanel == null) {
            this.latitudePositionPanel = new JPanel();
            this.latitudePositionPanel.setLayout(new GridBagLayout());
            this.latitudeLabel = new JLabel(Language.getString("dialog.parameter.astronomical.latitude", "Latitude") + ": ");
            String[] latitudeData = new String[]{"N", "S"};
            this.latitudeComboBox = new JComboBox<String>(latitudeData);
            this.latitudeDegree = new EditableNumericSpinner();
            this.latitudeMinute = new EditableNumericSpinner();
            this.latitudeSecond = new EditableNumericSpinner();
            this.latitudeDegree.setMinMax(0, 90);
            this.latitudeDegree.setColumns(3);
            this.latitudeDegree.addNumericSpinnerListener(new DegreeInputListener(1));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 10, 10, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.latitudePositionPanel.add((Component)this.latitudeLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 10, 10, 0);
            this.latitudePositionPanel.add((Component)this.latitudeComboBox, gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            this.latitudePositionPanel.add((Component)this.latitudeDegree, gbc);
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 5, 10, 0);
            this.latitudePositionPanel.add((Component)new JLabel("\u00b0"), gbc);
            gbc.gridx = 4;
            gbc.gridy = 0;
            this.latitudePositionPanel.add((Component)this.latitudeMinute, gbc);
            gbc.gridx = 5;
            gbc.gridy = 0;
            this.latitudePositionPanel.add((Component)new JLabel("'"), gbc);
            gbc.gridx = 6;
            gbc.gridy = 0;
            this.latitudePositionPanel.add((Component)this.latitudeSecond, gbc);
            gbc.insets = new Insets(4, 5, 10, 10);
            gbc.gridx = 7;
            gbc.gridy = 0;
            this.latitudePositionPanel.add((Component)new JLabel("\""), gbc);
        }
        return this.latitudePositionPanel;
    }

    private String[] getTimeZoneData() {
        String[] ret = new String[]{"GMT(+0)", "GMT(+1)", "GMT(+2)", "GMT(+3)", "GMT(+4)", "GMT(+5)", "GMT(+6)", "GMT(+7)", "GMT(+8)", "GMT(+9)", "GMT(+10)", "GMT(+11)", "GMT(12)", "GMT(-1)", "GMT(-2)", "GMT(-3)", "GMT(-4)", "GMT(-5)", "GMT(-6)", "GMT(-7)", "GMT(-8)", "GMT(-9)", "GMT(-10)", "GMT(-11)"};
        return ret;
    }

    public void loadFieldContents() {
        this.fJComboBox.setSelectedItem(this.parameter.getCity());
        if (this.fJComboBox.getSelectedItem() == null) {
            this.fJComboBox.setSelectedItem(Language.getString("dialog.parameter.astronomical.city.userDefined", "User defined"));
        }
        String selectedObject = this.fJComboBox.getSelectedItem().toString();
        this.setComponentEditable(selectedObject);
        this.loadLongitude(this.parameter.getLongitude());
        this.loadLatitude(this.parameter.getLatitude());
        int timeZoneValue = this.parameter.getTimeZone().getCurrentValue();
        if (timeZoneValue < 0) {
            timeZoneValue = Math.abs(timeZoneValue) + 12;
        }
        this.timeZoneComboBox.setSelectedIndex(timeZoneValue);
    }

    private void setComponentEditable(String selectedObject) {
        if (LogoXMLProperties.getInstance().isDefaultCity(selectedObject)) {
            this.removeButton.setVisible(false);
            this.saveButton.setVisible(false);
            this.cityNameLabel.setVisible(false);
            this.cityName.setVisible(false);
            this.setCityInfoEditable(false);
        } else if (selectedObject.equalsIgnoreCase(Language.getString("dialog.parameter.astronomical.city.userDefined", "User defined"))) {
            this.removeButton.setVisible(false);
            this.saveButton.setVisible(true);
            this.saveButton.setText(Language.getString("dialog.parameter.astronomical.save", "Save"));
            this.cityNameLabel.setVisible(true);
            this.cityName.setVisible(true);
            this.setCityInfoEditable(true);
        } else {
            this.removeButton.setVisible(true);
            this.saveButton.setVisible(true);
            this.saveButton.setText(Language.getString("dialog.parameter.astronomical.update", "Update"));
            this.cityNameLabel.setVisible(false);
            this.cityName.setVisible(false);
            this.setCityInfoEditable(true);
        }
    }

    private void setCityInfoEditable(boolean editable) {
        this.cityName.setEditable(editable);
        this.longitudeComboBox.setEnabled(editable);
        this.longitudeDegree.setEnabled(editable);
        this.longitudeMinute.setEnabled(editable);
        this.longitudeSecond.setEnabled(editable);
        this.latitudeComboBox.setEnabled(editable);
        this.latitudeDegree.setEnabled(editable);
        this.latitudeMinute.setEnabled(editable);
        this.latitudeSecond.setEnabled(editable);
        this.timeZoneComboBox.setEnabled(editable);
    }

    private void loadLongitude(AstronomicalClockParameter.Theodolite theodolite) {
        if (theodolite.getType() == -1) {
            return;
        }
        this.longitudeComboBox.setSelectedIndex(theodolite.getDir());
        this.longitudeDegree.setValue(theodolite.getDegree());
        this.longitudeMinute.setValue(theodolite.getMinute());
        this.longitudeSecond.setValue(theodolite.getSecond());
        if (theodolite.getDegree() >= 180) {
            this.longitudeMinute.setMinMax(0, 0);
            this.longitudeSecond.setMinMax(0, 0);
        } else {
            this.longitudeMinute.setMinMax(0, 59);
            this.longitudeSecond.setMinMax(0, 59);
        }
    }

    private void loadLatitude(AstronomicalClockParameter.Theodolite theodolite) {
        if (theodolite.getType() == -1) {
            return;
        }
        this.latitudeComboBox.setSelectedIndex(theodolite.getDir());
        this.latitudeDegree.setValue(theodolite.getDegree());
        this.latitudeMinute.setValue(theodolite.getMinute());
        this.latitudeSecond.setValue(theodolite.getSecond());
        if (theodolite.getDegree() >= 90) {
            this.latitudeMinute.setMinMax(0, 0);
            this.latitudeSecond.setMinMax(0, 0);
        } else {
            this.latitudeMinute.setMinMax(0, 59);
            this.latitudeSecond.setMinMax(0, 59);
        }
    }

    private void loadLongitude(String longitude) {
        if (longitude.equals("")) {
            return;
        }
        this.longitudeComboBox.setSelectedItem(String.valueOf(longitude.charAt(0)));
        this.longitudeDegree.setValue(Integer.parseInt(longitude.substring(1, longitude.indexOf("\u00b0"))));
        this.longitudeMinute.setValue(Integer.parseInt(longitude.substring(longitude.indexOf("\u00b0") + 1, longitude.indexOf("'"))));
        this.longitudeSecond.setValue(Integer.parseInt(longitude.substring(longitude.indexOf("'") + 1, longitude.indexOf("\""))));
    }

    private void loadLatitude(String latitude) {
        if (latitude.equals("")) {
            return;
        }
        this.latitudeComboBox.setSelectedItem(String.valueOf(latitude.charAt(0)));
        this.latitudeDegree.setValue(Integer.parseInt(latitude.substring(1, latitude.indexOf("\u00b0"))));
        this.latitudeMinute.setValue(Integer.parseInt(latitude.substring(latitude.indexOf("\u00b0") + 1, latitude.indexOf("'"))));
        this.latitudeSecond.setValue(Integer.parseInt(latitude.substring(latitude.indexOf("'") + 1, latitude.indexOf("\""))));
    }

    public boolean checkChanged() {
        return !Util.isObjectEqual(this.fJComboBox.getSelectedItem().toString(), this.parameter.getCity()) || this.parameter.getLongitude() == null || this.parameter.getLatitude() == null || !this.parameter.getLongitude().equals(this.getLongitude()) || !this.parameter.getLatitude().equals(this.getLatitude()) || this.parameter.getTimeZone().getCurrentValue() != this.getTimeZone();
    }

    public boolean checkFieldContents() {
        return this.longitudeDegree.checkValue(true) && this.longitudeMinute.checkValue(true) && this.longitudeSecond.checkValue(true) && this.latitudeDegree.checkValue(true) && this.latitudeMinute.checkValue(true) && this.latitudeSecond.checkValue(true);
    }

    public void storeFieldContents() {
        this.parameter.getLatitude().setDir(this.latitudeComboBox.getSelectedIndex());
        this.parameter.getLatitude().setDegree(this.latitudeDegree.getValue());
        this.parameter.getLatitude().setMinute(this.latitudeMinute.getValue());
        this.parameter.getLatitude().setSecond(this.latitudeSecond.getValue());
        this.parameter.getLongitude().setDir(this.longitudeComboBox.getSelectedIndex());
        this.parameter.getLongitude().setDegree(this.longitudeDegree.getValue());
        this.parameter.getLongitude().setMinute(this.longitudeMinute.getValue());
        this.parameter.getLongitude().setSecond(this.longitudeSecond.getValue());
        this.parameter.setTimeZone(this.getTimeZone());
        this.parameter.setCity(this.fJComboBox.getSelectedItem().toString());
    }

    private AstronomicalClockParameter.Theodolite getLongitude() {
        return new AstronomicalClockParameter.Theodolite(0, this.longitudeComboBox.getSelectedIndex(), this.longitudeDegree.getValue(), this.longitudeMinute.getValue(), this.longitudeSecond.getValue());
    }

    private AstronomicalClockParameter.Theodolite getLatitude() {
        return new AstronomicalClockParameter.Theodolite(1, this.latitudeComboBox.getSelectedIndex(), this.latitudeDegree.getValue(), this.latitudeMinute.getValue(), this.latitudeSecond.getValue());
    }

    private int getTimeZone() {
        int timeZone = this.timeZoneComboBox.getSelectedIndex();
        if (timeZone > 12) {
            timeZone = Integer.parseInt("-" + (timeZone - 12));
        }
        return timeZone;
    }

    private void setCityInfo(String name) {
        if (name.equalsIgnoreCase(Language.getString("dialog.parameter.astronomical.city.userDefined", "User defined"))) {
            this.loadLatitude(new AstronomicalClockParameter.Theodolite(1, 0, 0, 0, 0));
            this.loadLongitude(new AstronomicalClockParameter.Theodolite(0, 0, 0, 0, 0));
            this.cityName.setText("");
            this.timeZoneComboBox.setSelectedIndex(0);
            this.removeButton.setEnabled(false);
            this.saveButton.setText(Language.getString("dialog.parameter.astronomical.save", "Save"));
            this.cityName.setEditable(true);
        } else {
            String selectedCity = this.fJComboBox.getSelectedItem().toString();
            Iterator<String> cityIterator = LogoXMLProperties.getInstance().getCityInfo(selectedCity).iterator();
            this.cityName.setText(selectedCity);
            this.loadLongitude(cityIterator.next());
            this.loadLatitude(cityIterator.next());
            int timeZone = Integer.parseInt(cityIterator.next());
            if (timeZone < 0) {
                timeZone = Math.abs(timeZone) + 12;
            }
            this.timeZoneComboBox.setSelectedIndex(timeZone);
            this.cityName.setEditable(false);
            this.removeButton.setEnabled(true);
            this.saveButton.setText(Language.getString("dialog.parameter.astronomical.update", "Update"));
        }
    }

    public void setLatitudeLabel(String text) {
        this.latitudeLabel.setText(text);
    }

    public void setTimeZoneLabel(String text) {
        this.timeZoneLabel.setText(text);
    }

    public void setLongitudeLabel(String text) {
        this.longitudeLabel.setText(text);
    }

    class DegreeInputListener
    implements NumericSpinnerListener {
        public static final int LONGITUDE_TYPE = 0;
        public static final int LATITUDE_TYPE = 1;
        private int degree;

        public DegreeInputListener(int degree) {
            this.degree = degree;
        }

        public void spinnerChanged(SpinnerChangedEvent se) {
            if (this.degree == 0 && TheodolitePanel.this.longitudeDegree.getValue() == 180) {
                TheodolitePanel.this.longitudeMinute.setMax(0);
                TheodolitePanel.this.longitudeSecond.setMax(0);
            } else if (this.degree == 1 && TheodolitePanel.this.latitudeDegree.getValue() == 90) {
                TheodolitePanel.this.latitudeMinute.setMax(0);
                TheodolitePanel.this.latitudeSecond.setMax(0);
            } else {
                TheodolitePanel.this.longitudeMinute.setMinMax(0, 59);
                TheodolitePanel.this.latitudeMinute.setMinMax(0, 59);
                TheodolitePanel.this.longitudeSecond.setMinMax(0, 59);
                TheodolitePanel.this.latitudeSecond.setMinMax(0, 59);
            }
        }
    }
}

